<?php

namespace EssentialElements;

use function Breakdance\Elements\c;
use function Breakdance\Elements\PresetSections\getPresetSection;

\Breakdance\Elements\PresetSections\PresetSectionsController::getInstance()->register(
    "EssentialElements\\LessFancyBackground",
    c(
        "background",
        "Background",
        [c(
        "color",
        "Color",
        [],
        ['type' => 'color', 'layout' => 'inline'],
        false,
        true,
        [],
      ), c(
        "type",
        "Type",
        [],
        ['type' => 'button_bar', 'layout' => 'vertical', 'items' => [['value' => 'image', 'text' => 'Image'], ['text' => 'Gradient', 'value' => 'gradient']]],
        false,
        false,
        [],
      ), c(
        "image",
        "Image",
        [],
        ['type' => 'wpmedia', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']],
        true,
        true,
        [],
      ), c(
        "image_size",
        "Image Size",
        [],
        ['type' => 'media_size_dropdown', 'layout' => 'inline', 'condition' => [[['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']]], 'mediaSizeOptions' => ['imagePropertyPath' => 'design.background.image']],
        true,
        true,
        [],
      ), c(
        "lazy_load",
        "Lazy Load",
        [],
        ['type' => 'toggle', 'layout' => 'inline', 'condition' => [[['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']]]],
        false,
        false,
        [],
      ), c(
        "image_settings",
        "Image Settings",
        [c(
        "size",
        "Size",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'cover', 'text' => 'cover'], ['text' => 'contain', 'value' => 'contain'], ['text' => 'auto', 'value' => 'auto'], ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "width",
        "Width",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "height",
        "Height",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "repeat",
        "Repeat",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'repeat', 'text' => 'repeat'], ['text' => 'no-repeat', 'value' => 'no-repeat'], ['text' => 'repeat-x', 'value' => 'repeat-x'], ['text' => 'repeat-y', 'value' => 'repeat-y']]],
        true,
        false,
        [],
      ), c(
        "position",
        "Position",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'center top', 'text' => 'center top'], ['value' => 'center center', 'text' => 'center center'], ['value' => 'center bottom', 'text' => 'center bottom'], ['value' => 'left top', 'text' => 'left top'], ['value' => 'left center', 'text' => 'left center'], ['value' => 'left bottom', 'text' => 'left bottom'], ['value' => 'right top', 'text' => 'right top'], ['value' => 'right center', 'text' => 'right center'], ['value' => 'right bottom', 'text' => 'right bottom'], ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "custom_position",
        "Custom Position",
        [],
        ['type' => 'focus_point', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.image_settings.position', 'operand' => 'equals', 'value' => 'custom']],
        true,
        false,
        [],
      ), c(
        "attachment",
        "Attachment",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'scroll', 'text' => 'scroll'], ['text' => 'fixed', 'value' => 'fixed']]],
        true,
        false,
        [],
      ), c(
        "unset_image_at",
        "Unset Image At",
        [],
        ['type' => 'breakpoint_dropdown', 'layout' => 'inline'],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => [[['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']]]],
        false,
        false,
        [],
      ), c(
        "gradient",
        "Gradient",
        [],
        ['type' => 'color', 'layout' => 'vertical', 'colorOptions' => ['type' => 'gradientOnly'], 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "gradient_animation",
        "Gradient Animation",
        [c(
        "scale",
        "Scale",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['%']], 'rangeOptions' => ['min' => 100, 'max' => 500, 'step' => 10]],
        false,
        false,
        [],
      ), c(
        "speed",
        "Speed",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['s']], 'rangeOptions' => ['min' => 1, 'max' => 20, 'step' => 1]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "overlay",
        "Overlay",
        [c(
        "color",
        "Color",
        [],
        ['type' => 'color', 'layout' => 'inline'],
        false,
        true,
        [],
      ), c(
        "type",
        "Type",
        [],
        ['type' => 'button_bar', 'layout' => 'vertical', 'items' => [['value' => 'image', 'text' => 'Image'], ['text' => 'Gradient', 'value' => 'gradient']]],
        false,
        false,
        [],
      ), c(
        "image",
        "Image",
        [],
        ['type' => 'wpmedia', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']],
        true,
        true,
        [],
      ), c(
        "image_size",
        "Image Size",
        [],
        ['type' => 'media_size_dropdown', 'layout' => 'inline', 'condition' => [[['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']]]],
        true,
        true,
        [],
      ), c(
        "lazy_load",
        "Lazy Load",
        [],
        ['type' => 'toggle', 'layout' => 'inline', 'condition' => [[['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']]]],
        false,
        false,
        [],
      ), c(
        "image_settings",
        "Image Settings",
        [c(
        "size",
        "Size",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'cover', 'text' => 'cover'], ['text' => 'contain', 'value' => 'contain'], ['text' => 'auto', 'value' => 'auto'], ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "width",
        "Width",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.overlay.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "height",
        "Height",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.overlay.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "repeat",
        "Repeat",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'repeat', 'text' => 'repeat'], ['text' => 'no-repeat', 'value' => 'no-repeat'], ['text' => 'repeat-x', 'value' => 'repeat-x'], ['text' => 'repeat-y', 'value' => 'repeat-y']]],
        true,
        false,
        [],
      ), c(
        "position",
        "Position",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'center top', 'text' => 'center top'], ['value' => 'center center', 'text' => 'center center'], ['value' => 'center bottom', 'text' => 'center bottom'], ['value' => 'left top', 'text' => 'left top'], ['value' => 'left center', 'text' => 'left center'], ['value' => 'left bottom', 'text' => 'left bottom'], ['value' => 'right top', 'text' => 'right top'], ['value' => 'right center', 'text' => 'right center'], ['value' => 'right bottom', 'text' => 'right bottom'], ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "custom_position",
        "Custom Position",
        [],
        ['type' => 'focus_point', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.overlay.image_settings.position', 'operand' => 'equals', 'value' => 'custom']],
        true,
        false,
        [],
      ), c(
        "attachment",
        "Attachment",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => [['value' => 'scroll', 'text' => 'scroll'], ['text' => 'fixed', 'value' => 'fixed']]],
        true,
        false,
        [],
      ), c(
        "unset_image_at",
        "Unset Image At",
        [],
        ['type' => 'breakpoint_dropdown', 'layout' => 'inline'],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "gradient",
        "Gradient",
        [],
        ['type' => 'color', 'layout' => 'vertical', 'colorOptions' => ['type' => 'gradientOnly'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "gradient_animation",
        "Gradient Animation",
        [c(
        "scale",
        "Scale",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['%']], 'rangeOptions' => ['min' => 100, 'max' => 500, 'step' => 10]],
        false,
        false,
        [],
      ), c(
        "speed",
        "Speed",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['s']], 'rangeOptions' => ['min' => 1, 'max' => 20, 'step' => 1]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "opacity",
        "Opacity",
        [],
        ['type' => 'number', 'layout' => 'inline', 'rangeOptions' => ['min' => 0, 'max' => 1, 'step' => 0.1]],
        false,
        true,
        [],
      ), c(
        "effects",
        "Effects",
        [getPresetSection(
      "EssentialElements\\filter",
      "Filter",
      "filter",
       ['type' => 'popout']
     ), c(
        "blend_mode",
        "Blend Mode",
        [],
        ['type' => 'dropdown', 'layout' => 'vertical', 'items' => [['value' => 'normal', 'text' => 'normal'], ['value' => 'multiply', 'text' => 'multiply'], ['value' => 'screen', 'text' => 'screen'], ['value' => 'overlay', 'text' => 'overlay'], ['value' => 'darken', 'text' => 'darken'], ['value' => 'lighten', 'text' => 'lighten'], ['text' => 'color-dodge', 'value' => 'color-dodge'], ['text' => 'color-burn', 'value' => 'color-burn'], ['text' => 'hard-light', 'value' => 'hard-light'], ['text' => 'soft-light', 'value' => 'soft-light'], ['text' => 'difference', 'value' => 'difference'], ['text' => 'exclusion', 'value' => 'exclusion'], ['text' => 'hue', 'value' => 'hue'], ['text' => 'saturation', 'value' => 'saturation'], ['text' => 'color', 'value' => 'color'], ['text' => 'luminosity', 'value' => 'luminosity']]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'sectionOptions' => ['type' => 'popout']],
        false,
        false,
        [],
      ), c(
        "transition_duration",
        "Transition Duration",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['ms'], 'defaultType' => 'ms'], 'rangeOptions' => ['min' => 0, 'max' => 9900, 'step' => 100]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'sectionOptions' => ['preset' => ['slug' => 'EssentialElements\\LessFancyBackground']]],
        false,
        false,
        [],
      ),
    true,
    ['relativePropertyPathsToWhitelistInFlatProps' => ['image', 'overlay.image', 'image_settings.unset_image_at', 'image_settings.size', 'image_settings.height', 'image_settings.repeat', 'image_settings.position', 'image_settings.left', 'image_settings.top', 'image_settings.attachment', 'image_settings.custom_position', 'image_settings.width', 'overlay.image_settings.custom_position', 'image_size', 'overlay.image_size', 'overlay.type', 'image_settings']]
);

